# E0237: interface properties cannot be marked public explicitly

In TypeScript interfaces, all properties are public.
It is a syntax error to explicitly write the `public` keyword on an interface
property:

```typescript
interface Painter {
  public paintPixel(pos, color);
}

class CanvasPainter implements Painter {
  public paintPixel(pos, color) {
    // ...
  }
}
```

To fix this error, remove the `public` keyword from the interface property:

```typescript
interface Painter {
  paintPixel(pos, color);
}

class CanvasPainter implements Painter {
  public paintPixel(pos, color) {
    // ...
  }
}
```

Introduced in quick-lint-js version 2.6.0.
