# E0214: use of undeclared type

A TypeScript type annotation must refer to a class, enum, generic parameter,
interface, or type alias. It is an error to a type which does not exist:

```typescript-jsx
interface Response {
  ok: bool;
  error?: string;
  data?: object;
}

function padString(
  s: string,
  alignment: Alignment,
): string {
  /* ... */
}

const Title: FC = () => {
  return <h1>Welcome!</h1>;
};
```

To fix this error, fix the name of the referenced type:

```typescript
interface Response {
  ok: boolean;
  error?: string;
  data?: object;
}
```

Alternatively, declare the type:

```typescript
enum Alignment { LEFT, RIGHT, CENTER };

function padString(
  s: string,
  alignment: Alignment,
): string {
  /* ... */
}
```


Alternatively, import the type:

```typescript-jsx
import {type FC} from "react";

const Title: FC = () => {
  return <h1>Welcome!</h1>;
};
```

Alternatively, if the type is global in your environment, [write a
quick-lint-js.config file](https://quick-lint-js.com/config/).

Introduced in quick-lint-js version 2.5.0.
