# E0213: TypeScript's 'interface' feature is not allowed in JavaScript code

JavaScript does not support interfaces. It is a syntax error to write a
TypeScript interface in JavaScript code:

```javascript
interface Response<T> {
  ok: boolean;
  error?: string;
  data?: T;
}
```

To fix this error, rename your file to have a `.ts` or `.tsx` suffix.
Alternatively, use JSDoc to declare the interface:

```javascript
/**
 * @typedef {Object} Response
 * @prop {boolean} ok
 * @prop {string} [error]
 * @prop {Object} data
 */
```

Introduced in quick-lint-js version 2.5.0.
