# E0163: newline is not allowed between 'async' and arrow function parameter list

```config-for-examples
{
  "globals": {
    "app": true,
    "doHomePage": true
  }
}
```

An `async` arrow function has a parameter list following the `async` keyword. It
is a syntax error for the parameter list to start on line different from the
`async` keyword:

```javascript
app.get(
  "/",
  async
  (req, res) => {
    await doHomePage(req, res);
  },
);
```

To fix this error, write `async` on the same line as the parameter list by
removing the newline after `async`:

```javascript
app.get(
  "/",
  async (req, res) => {
    await doHomePage(req, res);
  },
);
```

Introduced in quick-lint-js version 0.3.0.
