# E0158: unexpected '=>'; expected parameter for arrow function, but got a literal instead

```config-for-examples
{
  "globals": {
    "userID": true,
    "groupID": true
  }
}
```

An arrow function has a parameter list followed by `=>` followed by a body. It
is a syntax error to write an arrow function with a literal instead of a
parameter list:

```javascript
let fs = require("fs");
let path = process.argv[2];
fs.readFile(path, "utf-8" => {
});

const queryUser = userID, groupID = 0 => {
  /* ... */
};
```

To fix this error, write a parameter list before `=>`:

```javascript
let fs = require("fs");
let path = process.argv[2];
fs.readFile(path, "utf-8", (err, data) => {
});
```

Alternatively, write `(` `)` around the parameter list:

```javascript
const queryUser = (userID, groupID = 0) => {
  /* ... */
};
```

Introduced in quick-lint-js version 0.3.0.
