# E0109: for-of loop expression cannot have semicolons

```config-for-examples
{
  "globals": {
    "collectBenchmarks": true,
    "runBenchmark": true
  }
}
```

There are three kinds of `for` loops: C-style `for` loops (`;`), `for`-`in`
loops, and `for`-`of` loops. It is a syntax error to write a `for`-`of` loop
with a `;`:

```javascript
for (let i of 0; i < 100; ++i) {
  console.log(i % 15 ? i : "FizzBuzz");
}

for (const benchmark of collectBenchmarks();) {
  runBenchmark(benchmark);
}
```

To fix this error, remove the `of` keyword in the C-style `for` loop:

```javascript
for (let i = 0; i < 100; ++i) {
  console.log(i % 15 ? i : "FizzBuzz");
}
```

Alternatively, remove the extra `;`:

```javascript
for (const benchmark of collectBenchmarks()) {
  runBenchmark(benchmark);
}
```

Introduced in quick-lint-js version 0.2.0.
