# E0106: missing body for 'switch' statement

`switch` statements require a body, which must be a list of statements
surrounded by `{` and `}`. It is a syntax error to omit the body of an `switch`
statement:

```javascript
function colorToHexCode(color) {
  switch (color)
}
```

To fix this error, write the body of the `switch` statement:

```javascript
function colorToHexCode(color) {
  switch (color) {
    case 'red':   return '#ff0000';
    case 'green': return '#00ff00';
    case 'blue':  return '#0000ff';
  }
}
```

Introduced in quick-lint-js version 0.2.0.
