# E0097: for loop needs an iterable, or condition and update clauses

```config-for-examples
{
  "globals": {
    "queue": true,
    "process": true
  }
}
```

There are three kinds of `for` loops: C-style `for` loops (`;`), `for`-`in`
loops, and `for`-`of` loops. It is a syntax error to write a `for` loop without
`;`, `in`, or `of`:

```javascript
for (queue.length > 0) {
  process(queue.pop());
}
```

To fix this error, use a `while` loop instead of a `for` loop:

```javascript
while (queue.length > 0) {
  process(queue.pop());
}
```

Introduced in quick-lint-js version 0.2.0.
