# E0026: missing operand for operator

Binary operators (such as `*` and `>>`) require an expression (e.g. a variable
or number) on both sides of the operator. Unary operators require an expression
before or after the operator (depending on the operator). Ternary operators
require three expressions. With some exceptions, it is an error to exclude an
expression:

```javascript
let ripe = true;
let tasty = true;
if (ripe && ) {
  console.log("delicious!")+;
}
```

To fix this error, add an expression, or remove the extraneous operator:

```javascript
let ripe = true;
let tasty = true;
if (ripe && tasty) {
  console.log("delicious!");
}
```

Note that sometimes, it *appears* that expressions can be omitted, but some
operators are binary *and* unary, and some operators look like other operators
conjoined. In these cases, the code might be completely valid, so quick-lint-js
won't report any error:

```javascript
3**5       // different than: 3 * * 5
3<<5       // different than: 3 < < 5
7 + - 8    // same as: 7 + (-8)
```

Introduced in quick-lint-js version 0.2.0.
