# E0711: missing expression in placeholder within template literal

Everytime you use `${}` within a template literal, which is a string defined
with backticks, such as this one below inside `console.log`, you should specify
an expression inside its curly braces.

```javascript
console.log(`My name is ${}`);
```

To fix this error, write an expression between `${` and `}`:

```javascript
const yourName = "Ryan";
console.log(`My name is ${yourName}`);
```

If your goals were to have the placeholder literally in your string, consider escaping it
using a backslash before the placeholder:

```javascript
console.log(`\${}`);
```

Or just use double-quoted string (`""`):

```javascript
console.log("${}");
```
