# E0458: typeof result is of type string and so will never equal undefined; use 'undefined' instead

The `typeof` operator will always return a string, so comparing to undefined will always yield false.
([MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/typeof))

```javascript
let x = undefined;
if (typeof x === undefined) {
    // this will never run!
    alert("x is undefined!");
}
```
Instead, compare against the string `"undefined"`:

```javascript
let x = undefined;
if (typeof x === "undefined") {
    // this will run now :)
    alert("x is undefined!");
}
```
