# E0348: unexpected '?' in type; use '| void' to make an optional type

Using a question mark as a prefix or suffix to make parameter types optional is invalid. Instead add a second 'void' type to the parameter.

```typescript
import * as fs from 'fs';

const file = "./out.txt";
const data = "test";

fs.promises.writeFile(file, data)
  .then((err: Error?) => {
    if (err) throw err;
  });
```

To fix this warning, we need to replace the '?' suffix or prefix with the expression '| void'

```typescript
import * as fs from 'fs';

const file = "./out.txt";
const data = "test";

fs.promises.writeFile(file, data)
  .then((err: Error | void) => {
    if (err) throw err;
  });
```
