# E0342: using equality or inequality operators against an arrow function will always produce the same result

Using equality or inequality operators against an arrow function will always yield the same result (false or true), e.g. In the code below, the equality operator is used by mistake against an arrow function.

```javascript
class Car {
  constructor(acceleration, speed) {
    this.acceleration = acceleration;
    this.speed = speed;
  }

  hitTheGas(acceleration) {
    this.acceleration += acceleration;
  }
};

let vehicle = new Car(0, 0);

let acceleration = (force) => {
  vehicle.hitTheGas(10 * force);
};

let sport_mode = true;

if (sport_mode) {
  acceleration == (force) => {
    vehicle.hitTheGas(15 * force);
  };
}
```

To fix this warning, we need to replace the equality operator with the assigment operator.

```javascript
class Car {
  constructor(acceleration, speed) {
    this.acceleration = acceleration;
    this.speed = speed;
  }

  hitTheGas(acceleration) {
    this.acceleration += acceleration;
  }
};

let vehicle = new Car(0, 0);

let acceleration = (force) => {
  vehicle.hitTheGas(10 * force);
};

let sport_mode = true;

if (sport_mode) {
  acceleration = (force) => {
    vehicle.hitTheGas(15 * force);
  };
}
```

Introduced in quick-lint-js version 2.10.0.
