# E0326: 'async export' is not allowed; write 'export async' instead

Functions can be marked using the `async` keyword like `async function f() {`.
It is a syntax error to write the `async` keyword after the `function` keyword:

```javascript
async export function f() {
  return 0;
}
```

To fix this error, replace `async export` with `export async`:

```javascript
export async function f() {
  return 0;
}
```
