# E0323: optional tuple elements cannot come after spread elements

TypeScript tuple types can contain spread elements and optional elements.
However, it is a syntax error to use both a spread element and an optional
element in a single tuple type:

```typescript
function foo(): [...number[], string?] {
  /* ... */
}
```

To fix this error, use a union type instead of an optional element:

```typescript
function foo(): [...number[]]
              | [...number[], string] {
  /* ... */
}
```

Introduced in quick-lint-js version 2.10.0.
