# E0321: expected '?' to mark tuple element as optional

TypeScript tuple types can contain optional elements. These optional elements
must be last. It is a syntax error to write a required tuple element after an
optional one:

```typescript
function parseVersion(
): [number, number?, string] {
  /* ... */
}
```

To fix this error, mark the tuple element as optional by adding `?`:

```typescript
function parseVersion(
): [number, number?, string?] {
  /* ... */
}
```

Alternatively, use a union type:

```typescript
function parseVersion(
): [number, number?]
 | [number, string]
 | [number, number, string] {
  /* ... */
}
```


Introduced in quick-lint-js version 2.10.0.
