# E0316: function overload signature must be named (function name)

In TypeScript, functions can have overload signatures. Each signature should
have the same name as the function. It is an error to write a different name in
an overload:

```typescript
function keys<T>(a: T[]): number[];
function key(a: object): string[];
function keys(a: object) {
  if (Array.isArray(a)) {
    return Object.keys(a).map(k => +k);
  } else {
    return Object.keys(a);
  }
}
```

To fix this error, write the function name correctly in each overload:

```typescript
function keys<T>(a: T[]): number[];
function keys(a: object): string[];
function keys(a: object) {
  /* ... */
}
```

Introduced in quick-lint-js version 2.10.0.
