# E0309: unexpected '?' when destructuring

In TypeScript, `?` can be used to mark a function parameter as optional. It is a
syntax error to write `?` when destructuring:

```typescript
type OneOrTwo<T> = [T] | [T, T];
function join1Or2(
  [first, second?]: OneOrTwo<string>,
) {
  return second ? first+second : first;
}
```

To fix this error, remove the `?`:

```typescript
type OneOrTwo<T> = [T] | [T, T];
function join1Or2(
  [first, second]: OneOrTwo<string>,
) {
  return second ? first+second : first;
}
```

Introduced in quick-lint-js version 2.10.0.
