# E0291: 'as const' is only allowed on literals (array, object, string, boolean) and enum members

```config-for-examples
{
  "globals": {
    "html": true
  }
}
```

In TypeScript, `as const` types an expression with a literal type. Expressions
which can have literal types include the following:

* Array literals (e.g. `[]`, `[first, second, third]`)
* Object literals (e.g. `{}`, `{ key: value }`)
* String literals (e.g. `''`, `'hello'`)
* Untagged template literals (e.g. <code>\`\`</code>, <code>\`hello\`</code>)
* `true`
* `false`
* Enum members (e.g. `LogLevel.DEBUG`)
* Any of the above wrapped in parentheses

It is an error to use `as const` on an expression which cannot have a literal
type:

```typescript
const DOCTYPE = html`<!DOCTYPE html>` as const;
```

To fix this error, remove `as const`:

```typescript
const DOCTYPE = html`<!DOCTYPE html>`;
```

Alternatively, change the expression so it is valid with `as const`:

```typescript
const DOCTYPE = `<!DOCTYPE html>` as const;
```

Introduced in quick-lint-js version 2.10.0.
