# E0285: generic arrow function needs ',' here in TSX

In TypeScript, generic arrow functions have syntax like `<P1, P2>(params) =>
body`. In JSX, elements have syntax like `<Element>{children}</Element>`.
Because of a possible ambiguity, generic arrow functions in TypeScript+JSX must
have at least one comma inside the parameter list:

```typescript-jsx
const reversed = <T>(array: T[]) =>
  [...array].reverse();
```

To fix this error, add a comma after the generic parameter:

```typescript-jsx
const reversed = <T,>(array: T[]) =>
  [...array].reverse();
```

Alternatively, write a normal function instead of an arrow function:

```typescript-jsx
function reversed<T>(array: T[]) {
  return [...array].reverse();
}
```

Introduced in quick-lint-js version 2.9.0.
