# E0272: 'type' cannot be used twice in import

When importing in TypeScript, `type` can be used to indicate that the symbol
should not be imported at run time. It is a syntax error to mix both `import
type ...` and `import {type ...}`:

```typescript
import type { ChangeEvent,
              createElement,
              type FC,
            } from "react";
```

To fix this error, use only the `import {type ...}` syntax:

```typescript
import { type ChangeEvent,
         createElement,
         type FC,
       } from "react";
```

Alternatively, use only the `import type ...` syntax, importing twice if you
also need run time imports:

```typescript
import type { ChangeEvent, FC } from "react";
import { createElement } from "react";
```

Introduced in quick-lint-js version 2.8.0.
