# E0269: 'async static' is not allowed; write 'static async' instead

```config-for-examples
{
  "globals": {
    "mysql": true
  }
}
```

Class methods can have modifiers such as `static`, `async`, and `*`. It is a
syntax error to write `async static` in a class method declaration:

```javascript
class Database {
  async static connect(host, login, database) {
    let db = await mysql.connect(host, login);
    await db.use(database);
    return new Database(db);
  }
}
```

To fix this error, replace `async static` with `static async`:

```javascript
class Database {
  static async connect(host, login, database) {
    let db = await mysql.connect(host, login);
    await db.use(database);
    return new Database(db);
  }
}
```

Introduced in quick-lint-js version 0.3.0.
