# E0268: TypeScript type imports cannot import both default and named exports

In TypeScript, `import type` can be used to import types from another module. It
is a syntax error to use `import type` to import both a default export (outside
`{` and `}`) and some named exports (inside `{` and `}`):

```typescript
import type Styles, {StyleMap} from "./Styles";
```

To fix this error, split the import into two:

```typescript
import type Styles from "./Styles";
import type {StyleMap} from "./Styles";
```

Introduced in quick-lint-js version 2.8.0.
