# E0259: '.' is not allowed after generic arguments

In TypeScript types, you can look up a property of a generic type using
`Type<Arg>["name"]` syntax. It is a syntax error to instead use `.` to look up a
property of a generic type:

```typescript
class Thing<T> {
  static thong: number;
}
type ThingThong<T>
  = typeof Thing<T>.thong;
```

To fix this error, write `["name"]` instead of `.name`:

```typescript
class Thing<T> {
  static thong: number;
}
type ThingThong<T>
  = typeof Thing<T>["thong"];
```

Introduced in quick-lint-js version 2.7.0.
