# E0244: abstract classes are not allowed in JavaScript

```config-for-examples
{
  "globals": {
    "LogSeverity": true
  }
}
```

Marking classes as `abstract` is a TypeScript feature. It is a syntax error to
write `abstract` before `class` in JavaScript:

```javascript
abstract class Logger {
  log(message) {
    this.logRaw(LogSeverity.INFO, message);
  }
}

class ConsoleLogger extends Logger {
  logRaw(severity, message) {
    console.log(message);
  }
}
```

To fix this error, remove the `abstract` keyword and rely on JavaScript's
dynamic typing:

```javascript
class Logger {
  log(message) {
    this.logRaw(LogSeverity.INFO, message);
  }
}

class ConsoleLogger extends Logger {
  logRaw(severity, message) {
    console.log(message);
  }
}
```

Introduced in quick-lint-js version 2.6.0.
