# E0241: newline is not allowed between field name and '!'

```config-for-examples
{
  "globals": {
    "BananaSkin": true
  }
}
```

In TypeScript, `!` after a field name indicates a *definite assignment
assertion*. It is a syntax error to put the field name on a different line from
`!`:

```typescript
class Banana {
  skin
    !: BananaSkin | undefined;

  peel() {
    this.skin = undefined;
  }
}
```

To fix this error, put `!` immediately after the field name, on the same line:

```typescript
class Banana {
  skin!: BananaSkin | undefined;

  peel() {
    this.skin = undefined;
  }
}
```

Introduced in quick-lint-js version 2.6.0.
