# E0236: assignment-asserted field must have a type annotation

```config-for-examples
{
  "globals": {
    "Address": true
  }
}
```

In TypeScript, `!` after a field name indicates a *definite assignment
assertion*. Definite-assignment-asserted fields must have a type annotation. It
is a syntax error to write `!` on a field without any type annotation:

```typescript
class AccountBuilder {
  name!;
  address!;

  setName(value: string) {
    this.name = value;
    return this;
  }

  setAddress(value: Address) {
    this.address = value;
    return this;
  }
}
```

To fix this error, write a type annotation:

```typescript
class AccountBuilder {
  name!: string;
  address!: Address;

  setName(value: string) {
    this.name = value;
    return this;
  }

  setAddress(value: Address) {
    this.address = value;
    return this;
  }
}
```

Alternatively, remove the `!`:

```typescript
class AccountBuilder {
  name;
  address;

  setName(value: string) {
    this.name = value;
    return this;
  }

  setAddress(value: Address) {
    this.address = value;
    return this;
  }
}
```

Introduced in quick-lint-js version 2.6.0.
