# E0233: TypeScript generics are not allowed in JavaScript code

It is a syntax error to write TypeScript generic parameters or arguments in
JavaScript code:

```javascript
class HashSet<Value> {
  // ...
}
```

To fix this error, rename your file to have a `.ts` or `.tsx` suffix.

Alternatively, use JSDoc to write the generic parameters:

```javascript
/**
 * @template Value
 */
class HashSet {
  // ...
}
```

Introduced in quick-lint-js version 2.6.0.
