# E0228: TypeScript optional properties are not allowed in JavaScript code

`?` on class properties is a TypeScript feature. It is a syntax error to write
`?` on a property in JavaScript code:

```javascript
class Entity {
  parent? = null;
}
```

To fix this error, erase the `?`:

```javascript
class Entity {
  parent = null;
}
```

Alternatively, rename your file to have a `.ts` or `.tsx` suffix

Introduced in quick-lint-js version 2.6.0.
