# E0225: index signatures require a value type

A TypeScript index signature has a key type and a value type. It is a syntax
error to omit the value type:

```typescript
interface StringArray {
  readonly [index: number];
}

interface StringDictionary {
  [k: string];
}
```

To fix this error, write `:` then the type of the value:

```typescript
interface StringArray {
  readonly [index: number]: string;
}

interface StringDictionary {
  [k: string]: any;
}
```

Introduced in quick-lint-js version 2.6.0.
