# E0221: TypeScript interface fields cannot be initalized

TypeScript interfaces describe the properties of objects, but do not describe
default values for those properties. It is a syntax error to initialize a
property with `=` in an interface:

```typescript
interface Entity {
  x: number = 0;
  y: number = 0;

  tick(): void;
}

class Player implements Entity {
  x: number;
  y: number;

  tick(): void {
    // ...
  }
}
```

To fix this error, convert the interface into an abstract base class:

```typescript
abstract class Entity {
  x: number = 0;
  y: number = 0;

  abstract tick(): void;
}

class Player extends Entity {
  tick(): void {
    // ...
  }
}
```

Alternatively, remove the initializer from the interface, making sure to
initialize in implementing classes:

```typescript
interface Entity {
  x: number;
  y: number;

  tick(): void;
}

class Player implements Entity {
  x: number = 0;
  y: number = 0;

  tick(): void {
    // ...
  }
}
```

Introduced in quick-lint-js version 2.6.0.
