# E0197: '“' is not allowed for strings; use " instead

JavaScript string literals start with either `"` or `'` (straight quotes). It is
a syntax error to use smart quotes instead of straight quotes to write a string
literal:

```javascript
let name = “Alice”;
console.log(‘hello, ’ + name);
```

To fix this error, replace `‘` and `’` with `'`, and replace `“` and `”` with
`"`:

```javascript
let name = "Alice";
console.log('hello, ' + name);
```

Introduced in quick-lint-js version 2.0.0.
