# E0183: '}' is not allowed directly in JSX text; write {'}'} instead

In the children of a JSX element, you can write arbitrary text. However, it is a
syntax error to write `}` unescaped in JSX text:

```javascript-jsx
function ClosingBrackets() {
  return <ul>
    <li>)</li>
    <li>]</li>
    <li>}</li>
  </ul>;
}
```

To fix this error, write `{'}'}` instead:

```javascript-jsx
function ClosingBrackets() {
  return <ul>
    <li>)</li>
    <li>]</li>
    <li>{"}"}</li>
  </ul>;
}
```

Introduced in quick-lint-js version 2.0.0.
