# E0160: unexpected '=>'; expected parameter for arrow function, but got an expression instead

The left-hand side of `=>` must be a list of parameters. It is a syntax error if
the left-hand side is instead an expression (such as a property access or a
function call):

```javascript
if (this.mapSize => this.capacity) {
  throw new Error("too many items");
}

let fs = require("fs");
let path = process.argv[2];
fs.mkdir(path () => console.log("done"));
```

To fix this error, replace `=>` with the intended operator, such as `>=`:

```javascript
if (this.mapSize >= this.capacity) {
  throw new Error("too many items");
}
```

Alternatively, make the left-hand side of `=>` valid by adding an operator
(usually `,`) before the parameter list:

```javascript
let fs = require("fs");
let path = process.argv[2];
fs.mkdir(path, () => console.log("done"));
```

Introduced in quick-lint-js version 0.3.0.
