# E0148: missing body for statement; a function statement is not allowed as the body of statement

```config-for-examples
{
  "globals": {
    "config": true
  }
}
```

`do`-`while` loops, `for` loops, `while` loops, and `with` statements require a
statement or list of statements for the body. It is a syntax error to write a
function as the body of such a statement:

```javascript
let flavors = [];
for (let flavor in config.sweets)

function getFavoriteFlavor() {
  return "chocolate";
}
```

To fix this error, write the body of the `do`-`while` loop, `for` loop, `while`
loop, or `with` statement:

```javascript
let flavors = [];
for (let flavor in config.sweets) {
  flavors.push(flavor);
}

function getFavoriteFlavor() {
  return "chocolate";
}
```

Introduced in quick-lint-js version 0.2.0.
