# E0147: unexpected identifier in expression; missing operator before

```config-for-examples
{
  "globals": {
    "add": true,
    "dos": true,
    "two": true
  }
}
```

It is an error to write two variable names without an operator in between:

```javascript
const quatro = (dos dos);
const four = add(two two);
```

To fix this error, remove one of the variables, or add an operator:

```javascript
const quatro = (dos + dos);
const four = add(two, two);
```

Introduced in quick-lint-js version 0.2.0.
