# E0142: missing property name after '.' operator

```config-for-examples
{
  "globals": {
    "goNuts": true
  }
}
```

The `.` operator accesses an object's property. It is a syntax error to omit a
property name after the `.` operator:

```javascript
try {
  goNuts();
} catch {
  console.("couldn't handle deez nuts");
}
```

To fix this error, write the property name after the `.`:

```javascript
try {
  goNuts();
} catch {
  console.error("couldn't handle deez nuts");
}
```

Introduced in quick-lint-js version 0.2.0.
