# E0138: missing condition for if statement

```config-for-examples
{
  "globals": {
    "person": true
  }
}
```

An `if` statement has a condition which determines whether the body will execute
or not. It is an error to omit an `if` statement's condition:

```javascript
let firstName = person.firstName;
let lastName = person.lastName;
if {
  firstName = lastName;
}
```

To fix this error, write the condition with parentheses after the `if` keyword:

```javascript
let firstName = person.firstName;
let lastName = person.lastName;
if (firstName === "") {
  firstName = lastName;
}
```

Introduced in quick-lint-js version 0.2.0.
