# E0135: expected variable name for 'catch'

```config-for-examples
{
  "globals": {
    "downloadURL": true
  }
}
```

A `try` statement can have a `catch` clause. The `catch` clause can define a
variable for the caught exception. It is a syntax error to write a string
literal instead of a variable name between a `catch` clause's parentheses:

```javascript
async function downloadURLWithRetries(url) {
  for (;;) {
    try {
      return await downloadURL(url);
    } catch ('ETIMEOUT') {
      // Loop and try again.
    }
  }
}
```

To fix this error, replace the string literal with a variable name:

```javascript
async function downloadURLWithRetries(url) {
  for (;;) {
    try {
      return await downloadURL(url);
    } catch (e) {
      if (e.code === 'ETIMEOUT') {
        // Loop and try again.
      } else {
        throw e;
      }
    }
  }
}
```

Introduced in quick-lint-js version 0.2.0.
