# E0122: missing catch or finally clause for try statement

```config-for-examples
{
  "globals": {
    "fs": true,
    "parseConfig": true
  }
}
```

A `try` statement has a list of statements followed by an optional `catch` block
followed by an optional `finally` block. It is a syntax error to omit both the
`catch` block and the `finally` block:

```javascript
async function readConfig(configFilePath) {
  try {
    let data = await fs.promises.readFile(
      configFilePath,
      "utf-8",
    );
    return parseConfig(data);
  }
}

let recursionDepth = 0;
function recursionExample() {
  if (recursionDepth > 100) {
    throw new Error("too much recursion!");
  }
  recursionDepth += 1;
  try {
    recursionExample();
  }
}
```

To fix this error, remove the `try` keyword:

```javascript
async function readConfig(configFilePath) {
  let data = await fs.promises.readFile(
    configFilePath,
    "utf-8",
  );
  return parseConfig(data);
}
```

Alternatively, add a `catch` block after the `try` block:

```javascript
async function readConfig(configFilePath) {
  try {
    let data = await fs.promises.readFile(
      configFilePath,
      "utf-8",
    );
    return parseConfig(data);
  } catch (error) {
    if (error.code === 'ENOENT') {
      return {};
    } else {
      throw error;
    }
  }
}
```

Alternatively, add a `finally` block after the `try` block:

```javascript
let recursionDepth = 0;
function recursionExample() {
  if (recursionDepth > 100) {
    throw new Error("too much recursion!");
  }
  recursionDepth += 1;
  try {
    recursionExample();
  } finally {
    recursionDepth -= 1;
  }
}
```

Introduced in quick-lint-js version 0.2.0.
