# E0120: missing body for try statement

`try` statements require a body, which must be a list of statements
surrounded by `{` and `}`. It is a syntax error to omit the body of a `try`
statement:

```javascript
let recursionDepth = 0;
function recursionExample() {
  if (recursionDepth > 100) {
    throw new Error("too much recursion!");
  }
  recursionDepth += 1;
  try
  finally {
    recursionDepth -= 1;
  }
}
```

To fix this error, write the body of the `try` statement:

```javascript
let recursionDepth = 0;
function recursionExample() {
  if (recursionDepth > 100) {
    throw new Error("too much recursion!");
  }
  recursionDepth += 1;
  try {
    recursionExample();
  } finally {
    recursionDepth -= 1;
  }
}
```

Introduced in quick-lint-js version 0.2.0.
