# E0118: unexpected 'finally' without 'try'

`try` statements can have a `finally` clause. It is a syntax error to have a
`finally` clause with no corresponding `try` statement:

```javascript-ignoring-extra-errors
let recursionDepth = 0;
function recursionExample() {
  if (recursionDepth > 100) {
    throw new Error("too much recursion!");
  }
  recursionDepth += 1;
  try {
    recursionExample();
  };
  finally {
    recursionDepth -= 1;
  }
}
```

To fix this error, make sure the `finally` keyword immediately follows the `}`
for a `try` block or a `catch` block:

```javascript
let recursionDepth = 0;
function recursionExample() {
  if (recursionDepth > 100) {
    throw new Error("too much recursion!");
  }
  recursionDepth += 1;
  try {
    recursionExample();
  }
  finally {
    recursionDepth -= 1;
  }
}
```

Introduced in quick-lint-js version 0.2.0.
