# E0110: for-in loop expression cannot have semicolons

```config-for-examples
{
  "globals": {
    "collectBenchmarks": true,
    "runBenchmark": true
  }
}
```

There are three kinds of `for` loops: C-style `for` loops (`;`), `for`-`in`
loops, and `for`-`of` loops. It is a syntax error to write a `for`-`in` loop
with a `;`:

```javascript
for (let i in 0; i < 100; ++i) {
  console.log(i % 15 ? i : "FizzBuzz");
}

let benchmarks = collectBenchmarks();
for (const name in benchmarks;) {
  runBenchmark(name, benchmarks[name]);
}
```

To fix this error, remove the `in` keyword in the C-style `for` loop:

```javascript
for (let i = 0; i < 100; ++i) {
  console.log(i % 15 ? i : "FizzBuzz");
}
```

Alternatively, remove the extra `;`:

```javascript
let benchmarks = collectBenchmarks();
for (const name in benchmarks) {
  runBenchmark(name, benchmarks[name]);
}
```

Introduced in quick-lint-js version 0.2.0.
