# E0101: missing body for do-while loop

```config-for-examples
{
  "globals": {
    "isDigit": true,
    "queue": true
  }
}
```

`do`-`while` loops require a body, which must be a statement or `{` `}`
surrounding a list of statements. It is a syntax error to omit the body of a
`do`-`while` loop:

```javascript
function skipNumber(parser) {
  do
  while (isDigit(parser.peek()));
}

do while (queue.length > 0) {
  queue.pop().run();
}
```

To fix this error, write the body of the `do`-`while` loop:

```javascript
function skipNumber(parser) {
  do parser.next();
  while (isDigit(parser.peek()));
}
```

Alternatively, remove the extraneous `do` keyword:

```javascript
while (queue.length > 0) {
  queue.pop().run();
}
```

Introduced in quick-lint-js version 0.2.0.
