# E0084: do-while loop needs parentheses around condition

`do`-`while` loops have a condition after the `while` keyword. It is a syntax
error to write a condition without `(` and `)`:

```javascript
let name;
do {
  name = prompt('What is your name?');
} while name === '';
```

To fix this error, write `(` before the condition and `)` after the condition:

```javascript
let name;
do {
  name = prompt('What is your name?');
} while (name === '');
```

Introduced in quick-lint-js version 0.2.0.
