# E0073: missing function parameter list

Functions declared with `function` can have zero or more parameters. It is a
syntax error to omit the parameter list, including `(` and `)`, even if the
function has no parameters:

```javascript
class Doge {
  speak {
    console.log('many woofie');
  }
}

function visitDogPark {
  new Doge().speak();
}

setInterval(
  function {
    visitDogPark();
  },
  1000,
);
```

To fix this error, add a pair of parentheses before `{` in the function:

```javascript
class Doge {
  speak() {
    console.log('many woofie');
  }
}

function visitDogPark() {
  new Doge().speak();
}

setInterval(
  function() {
    visitDogPark();
  },
  1000,
);
```

Introduced in quick-lint-js version 0.2.0.
