# E0047: unexpected characters in octal literal

Octal number literals start with `0` or `0o` and can only contain digits `0`
through `7` (and optionally an `n` to signify a `BigInt`). It is an error to
include other digits in octal number literals:

```javascript
let permissions = 0o755N;
let bcdDigits = 0o0123456789;
let million = 0o1e6;
```

To fix this error, fix or remove the extra digits or letters:

```javascript
let permissions = 0o755n;
```

Alternatively, convert the octal number literal into a decimal or hexadecimal
number literal:

```javascript
let bcdDigits = 123456789;
let million = 1e6;
```

Introduced in quick-lint-js version 0.2.0.
