# E0044: unexpected characters in number literal

```config-for-examples
{
  "globals": {
    "pi": true
  }
}
```

Letters are allowed in number literals in certain situations, such as in
`123n`, `1e6`, and `0xff`. It is an error to include other letters or letters in
the wrong spot:

```javascript
let big = 9007199254740991N;
let pi = 3.14l;
let tau = 2pi;
```

To fix this error, use the correct letter or remove the extraneous letter:

```javascript
let big = 9007199254740991n;
let pi = 3.14;
```

Alternatively, use the `*` operator to multiply a variable by a number:

```javascript
let tau = 2*pi;
```

Introduced in quick-lint-js version 0.2.0.
