# E0035: RegExp literal flags cannot contain Unicode escapes

```config-for-examples
{
  "globals": {
    "headerName": true
  }
}
```

Regular expression literals can contain flags. These flags must not be escaped
using a Unicode escape sequence:

```javascript
const isContentLength =
  /content-length/\u{69}.test(headerName);
```

To fix this error, stop being clever; write the flag letter directly:

```javascript
const isContentLength =
  /content-length/i.test(headerName);
```

Introduced in quick-lint-js version 0.2.0.
