# E0019: escaping '-' is not allowed in tag names; write '-' instead

JSX tag names and attributes can contain Unicode escape sequences starting with
`\u`. It is a syntax error for a Unicode escape sequence to resolve to the `-`
character (U+002D):

```javascript-jsx
function Font() {
  return <svg:font\u{2d}face font\u002dfamily="Helvetica Standard" />;
}
```

To fix this error, write `-` instead of `\u{2d}` or `\u002d`:

```javascript-jsx
function Font() {
  return <svg:font-face font-family="Helvetica Standard" />;
}
```

Introduced in quick-lint-js version 2.0.0.
